using System;
using System.Drawing;
using System.Reflection;
using System.Resources;

namespace gov.va.med.vbecs.GUI.controls
{	
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Stanislav Antropov</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>12/22/2004</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	/// <summary>
	/// Encapsulates access to dynamically loaded and assigned icons used in both VBECS itself and MUCs.
	/// </summary>

	#endregion

	public class VbecsIcon
	{
		/// <summary>
		/// Beware - resource names are case sensitive!
		/// </summary>
		public static readonly VbecsIcon 
			VistALinkConnected = new VbecsIcon( "VISTALINK.ICO" ),
			VistALinkDown = new VbecsIcon( "VISTALINKFAIL.ICO" ),
			PatientAlert = new VbecsIcon( "patientalert.ico" ),
			OrderAlert = new VbecsIcon( "orderalert.ico" ),
			TransparentAlert = new VbecsIcon( "transparent.ico" ),
			SymFailure = new VbecsIcon( "sym_failure.ico" ),
			SymSuccess = new VbecsIcon( "sym_success.ico" ),
			Save = new VbecsIcon( "smallsave.ico" );
		
		private const string IconAssemblyFolderResourcePathBase = "gov.va.med.vbecs.AppResources.Images";

		private Icon _icon;

		static VbecsIcon() {} // getting rid of 'beforefieldinit' attribute

		private static string FormResourceIconPath( string iconFileName )
		{
			return string.Concat( IconAssemblyFolderResourcePathBase, ".", iconFileName );
		}

		private VbecsIcon( string iconResourceName )
		{
			if( iconResourceName == null )
				throw( new ArgumentNullException( "iconResourceName" ) );

			_icon = new Icon( Assembly.Load( Common.VbecsConfig.ResourceAssemblyName ).GetManifestResourceStream( FormResourceIconPath( iconResourceName ) ) );			
		}

		/// <summary>
		/// Icon loaded from assembly resources.
		/// </summary>
		public Icon Icon
		{
			get
			{
				return _icon;
			}
		}
	}

	/// <summary>
	/// Class VbecsImage
	/// </summary>
	public class VbecsImage
	{
		/// <summary>
		/// Beware - resource names are case sensitive!
		/// </summary>
		public static readonly VbecsImage 
			Save = new VbecsImage( "small_save.gif" ),
			Transparent = new VbecsImage( "transparent.gif" ),
			VbecsLogo = new VbecsImage( "vbecs.gif" ),
			VbecsTestLogo = new VbecsImage( "vbecs-test.gif" );
		
		private const string ImageAssemblyFolderResourcePathBase = "gov.va.med.vbecs.AppResources.Images";

		private Bitmap _image;

		/// <summary>
		/// Static Constructor
		/// </summary>
		static VbecsImage() {} // getting rid of 'beforefieldinit' attribute

		private static string FormResourceImagePath( string imageFileName )
		{
			return string.Concat( ImageAssemblyFolderResourcePathBase, ".", imageFileName );
		}

		private VbecsImage( string imageResourceName )
		{
			if( imageResourceName == null )
				throw( new ArgumentNullException( "imageResourceName" ) );

			_image = new System.Drawing.Bitmap( Assembly.Load( Common.VbecsConfig.ResourceAssemblyName ).GetManifestResourceStream( FormResourceImagePath( imageResourceName ) ) );			
		}

		/// <summary>
		/// Image loaded from assembly resources.
		/// </summary>
		public Bitmap Image
		{
			get
			{
				return _image;
			}
		}
	}
}
